import java.util.*;

public class CaveRabbits {
    static int[] jumps;
    static List<List<Integer>> graph;
    static int[] platforms;
    static int[] changes;

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);
        int N = scanner.nextInt();
        jumps = new int[N + 1];
        graph = new ArrayList<>();
        platforms = new int[N + 1];
        changes = new int[N + 1];

        for (int i = 0; i <= N; i++) {
            graph.add(new ArrayList<>());
        }

        for (int i = 0; i < N - 1; i++) {
            int U = scanner.nextInt();
            int V = scanner.nextInt();
            graph.get(U).add(V);
        }

        for (int i = 1; i <= N; i++) {
            platforms[i] = scanner.nextInt();
        }

        for (int i = 1; i <= N; i++) {
            changes[i] = scanner.nextInt();
        }

        dfs(1, 0);

        for (int i = 1; i <= N; i++) {
            System.out.print(jumps[i] + " ");
        }
    }

    static void dfs(int room, int jumpsSoFar) {
        if (platforms[room] == 0) {
            jumps[room] = -1;
            return;
        }

        if (changes[room] != 0) {
            platforms[room] = 1 - platforms[room];
        }

        jumps[room] = jumpsSoFar;

        for (int nextRoom : graph.get(room)) {
            dfs(nextRoom, jumpsSoFar + 1);
        }

        if (changes[room] != 0) {
            platforms[room] = 1 - platforms[room];
        }
    }
}